/*************************************************************************************************
 * Copyright (c) 2007, Freescale Semiconductor
 *
 * File name   : typedef.h
 * Project name: JM60 Evaluation code
 *
  * Description : This software evaluates JM60 USB module 
 *               
 *
 * History     :
 * 04/01/2007  : Initial Development
 * 
 *************************************************************************************************/


#ifndef _TYPEDEF_H
#define _TYPEDEF_H

typedef unsigned char   byte;           // 8-bit
typedef unsigned int    word;           // 16-bit
typedef unsigned long   dword;          // 32-bit

typedef union _BYTE
{
    byte _byte;
    struct
    {
        unsigned b0:1;
        unsigned b1:1;
        unsigned b2:1;
        unsigned b3:1;
        unsigned b4:1;
        unsigned b5:1;
        unsigned b6:1;
        unsigned b7:1;
    }Bit;
} BYTE;

typedef union _WORD
{
    word _word;
    struct
    {
        byte byte1;
        byte byte0;
    }_byte;
    struct
    {
        BYTE HighB;
        BYTE LowB;
    }_Byte;
} WORD;

#define LSB(a)      ((a)._byte.byte0)
#define MSB(a)      ((a)._byte.byte1)

typedef union _DWORD
{
    dword _dword;
    struct
    {
        byte byte3;
        byte byte2;
        byte byte1;
        byte byte0;
    }_byte;
    struct
    {
        word word1;
        word word0;
    }_word;
    struct
    {
        BYTE Byte3;
        BYTE Byte2;
        BYTE Byte1;
        BYTE Byte0;
    }_Byte;
    struct
    {
        WORD Word1;
        WORD Word0;
    }_Word;
} DWORD;

#define LOWER_LSB(a)    ((a)._byte.byte0)
#define LOWER_MSB(a)    ((a)._byte.byte1)
#define UPPER_LSB(a)    ((a)._byte.byte2)
#define UPPER_MSB(a)    ((a)._byte.byte3)

typedef void(* pFunc)(void);

typedef union _POINTER
{
    struct
    {
        byte bHigh;
        byte bLow;
    }_byte;
    
    word _word;                   // bLow & bHigh
    byte* bMem;                   // 2 bytes pointer pointing
    word* wMem;                   // 2 bytes poitner pointing
                                 
} PTR_TYPE;

#endif            
